<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invoice_recurring_setting_items', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('invoice_recurring_setting_id')->nullable();
            $table->unsignedBigInteger('invoice_type_id')->nullable();
            $table->decimal('amount')->default(0);
            $table->mediumText('description');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoice_recurring_setting_items');
    }
};
