SET FOREIGN_KEY_CHECKS=0;
--
-- Table structure for table `agreement_histories`
--

DROP TABLE IF EXISTS `agreement_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `agreement_histories` (
                                       `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                       `sender_id` bigint(20) unsigned DEFAULT NULL,
                                       `recipient_id` bigint(20) unsigned DEFAULT NULL,
                                       `bulk_envelope_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                       `envelope_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                       `error_details` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                       `recipient_signing_uri` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                       `recipient_signing_uri_error` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                       `status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                       `status_date_time` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                       `uri` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                       `is_test` tinyint(4) NOT NULL DEFAULT '0',
                                       `created_at` timestamp NULL DEFAULT NULL,
                                       `updated_at` timestamp NULL DEFAULT NULL,
                                       `deleted_at` timestamp NULL DEFAULT NULL,
                                       PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `banks`
--

DROP TABLE IF EXISTS `banks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `banks` (
                         `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                         `gateway_id` bigint(20) unsigned NOT NULL,
                         `owner_user_id` bigint(20) unsigned DEFAULT NULL,
                         `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                         `details` tinytext COLLATE utf8mb4_unicode_ci,
                         `account_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                         `account_number` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                         `status` tinyint(4) NOT NULL DEFAULT '0',
                         `created_at` timestamp NULL DEFAULT NULL,
                         `updated_at` timestamp NULL DEFAULT NULL,
                         `deleted_at` timestamp NULL DEFAULT NULL,
                         PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
--
-- Table structure for table `core_pages`
--

DROP TABLE IF EXISTS `core_pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `core_pages` (
                              `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                              `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                              `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                              `summary` tinytext COLLATE utf8mb4_unicode_ci,
                              `content` tinytext COLLATE utf8mb4_unicode_ci,
                              `status` tinyint(4) NOT NULL DEFAULT '1',
                              `created_at` timestamp NULL DEFAULT NULL,
                              `updated_at` timestamp NULL DEFAULT NULL,
                              `deleted_at` timestamp NULL DEFAULT NULL,
                              PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `currencies`
--

DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `currencies` (
                          `id` bigint unsigned NOT NULL AUTO_INCREMENT,
                          `currency_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                          `symbol` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                          `currency_placement` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'before' COMMENT 'before, after',
                          `current_currency` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1' COMMENT 'Active,Deactivate',
                          `created_at` timestamp NULL DEFAULT NULL,
                          `updated_at` timestamp NULL DEFAULT NULL,
                          `deleted_at` timestamp NULL DEFAULT NULL,
                          PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `currencies`
--

--
-- Table structure for table `domains`
--

DROP TABLE IF EXISTS `domains`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `domains` (
                           `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
                           `domain` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
                           `custom` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                           `owner_user_id` int(10) unsigned DEFAULT NULL,
                           `tenant_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                           `created_at` timestamp NULL DEFAULT NULL,
                           `updated_at` timestamp NULL DEFAULT NULL,
                           PRIMARY KEY (`id`),
                           UNIQUE KEY `domains_domain_unique` (`domain`),
                           KEY `domains_tenant_id_foreign` (`tenant_id`),
                           CONSTRAINT `domains_tenant_id_foreign` FOREIGN KEY (`tenant_id`) REFERENCES `tenancies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `email_templates`
--

DROP TABLE IF EXISTS `email_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `email_templates` (
                                   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                   `owner_user_id` bigint(20) unsigned NOT NULL COMMENT 'owner user id',
                                   `category` tinyint(4) NOT NULL,
                                   `subject` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                   `body` longtext COLLATE utf8mb4_unicode_ci,
                                   `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '1 for active 0 for default',
                                   `created_at` timestamp NULL DEFAULT NULL,
                                   `updated_at` timestamp NULL DEFAULT NULL,
                                   `deleted_at` timestamp NULL DEFAULT NULL,
                                   PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `expense_types`
--

DROP TABLE IF EXISTS `expense_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expense_types` (
                                 `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                 `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                                 `tax` decimal(12,3) NOT NULL DEFAULT '0.000',
                                 `owner_user_id` bigint(20) unsigned DEFAULT NULL,
                                 `status` tinyint(4) DEFAULT '1' COMMENT '0=deactivate,1=active',
                                 `created_at` timestamp NULL DEFAULT NULL,
                                 `updated_at` timestamp NULL DEFAULT NULL,
                                 `deleted_at` timestamp NULL DEFAULT NULL,
                                 PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `expenses`
--

DROP TABLE IF EXISTS `expenses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expenses` (
                            `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                            `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                            `owner_user_id` bigint(20) unsigned DEFAULT NULL,
                            `property_id` bigint(20) unsigned DEFAULT NULL,
                            `property_unit_id` bigint(20) unsigned DEFAULT NULL,
                            `expense_type_id` bigint(20) unsigned DEFAULT NULL,
                            `description` mediumtext COLLATE utf8mb4_unicode_ci,
                            `total_amount` decimal(12,2) NOT NULL DEFAULT '0.00',
                            `responsibilities` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '1=tenant, 2=owner',
                            `created_at` timestamp NULL DEFAULT NULL,
                            `updated_at` timestamp NULL DEFAULT NULL,
                            `deleted_at` timestamp NULL DEFAULT NULL,
                            PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `failed_jobs` (
                               `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                               `uuid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                               `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
                               `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
                               `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
                               `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
                               `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                               PRIMARY KEY (`id`),
                               UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `faqs`
--

DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `faqs` (
                        `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                        `question` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                        `answer` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
                        `status` tinyint(4) NOT NULL DEFAULT '1',
                        `created_at` timestamp NULL DEFAULT NULL,
                        `updated_at` timestamp NULL DEFAULT NULL,
                        `deleted_at` timestamp NULL DEFAULT NULL,
                        PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `features`
--

DROP TABLE IF EXISTS `features`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `features` (
                            `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                            `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                            `summary` tinytext COLLATE utf8mb4_unicode_ci,
                            `status` tinyint(4) NOT NULL DEFAULT '1',
                            `created_at` timestamp NULL DEFAULT NULL,
                            `updated_at` timestamp NULL DEFAULT NULL,
                            `deleted_at` timestamp NULL DEFAULT NULL,
                            PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `file_managers`
--

DROP TABLE IF EXISTS `file_managers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `file_managers` (
                                 `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                 `folder_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                 `file_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                 `file_size` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                 `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                 `origin_id` bigint(20) unsigned DEFAULT NULL,
                                 `created_at` timestamp NULL DEFAULT NULL,
                                 `updated_at` timestamp NULL DEFAULT NULL,
                                 `deleted_at` timestamp NULL DEFAULT NULL,
                                 PRIMARY KEY (`id`),
                                 KEY `file_managers_origin_type_origin_id_index` (`origin_type`,`origin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gateway_currencies`
--

DROP TABLE IF EXISTS `gateway_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gateway_currencies` (
                                      `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                      `gateway_id` bigint(20) unsigned NOT NULL,
                                      `owner_user_id` bigint(20) unsigned DEFAULT NULL,
                                      `currency` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'USD',
                                      `conversion_rate` decimal(12,2) NOT NULL DEFAULT '1.00',
                                      `created_at` timestamp NULL DEFAULT NULL,
                                      `updated_at` timestamp NULL DEFAULT NULL,
                                      `deleted_at` timestamp NULL DEFAULT NULL,
                                      PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gateways`
--

DROP TABLE IF EXISTS `gateways`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gateways` (
                            `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                            `owner_user_id` bigint(20) unsigned DEFAULT NULL,
                            `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                            `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                            `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                            `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '1=Active,0=Disable',
                            `mode` tinyint(4) NOT NULL DEFAULT '2' COMMENT '1=live,2=sandbox',
                            `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                            `key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'client id, public key, key, store id, api key',
                            `secret` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'client secret, secret, store password, auth token',
                            `created_at` timestamp NULL DEFAULT NULL,
                            `updated_at` timestamp NULL DEFAULT NULL,
                            `deleted_at` timestamp NULL DEFAULT NULL,
                            PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `how_it_works`
--

DROP TABLE IF EXISTS `how_it_works`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `how_it_works` (
                                `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                                `summary` tinytext COLLATE utf8mb4_unicode_ci,
                                `content` tinytext COLLATE utf8mb4_unicode_ci,
                                `status` tinyint(4) NOT NULL DEFAULT '1',
                                `created_at` timestamp NULL DEFAULT NULL,
                                `updated_at` timestamp NULL DEFAULT NULL,
                                `deleted_at` timestamp NULL DEFAULT NULL,
                                PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `information`
--

DROP TABLE IF EXISTS `information`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `information` (
                               `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                               `property_id` int(10) unsigned NOT NULL,
                               `owner_user_id` bigint(20) unsigned DEFAULT NULL,
                               `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                               `distance` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                               `additional_information` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                               `contact_number` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                               `deleted_at` timestamp NULL DEFAULT NULL,
                               `created_at` timestamp NULL DEFAULT NULL,
                               `updated_at` timestamp NULL DEFAULT NULL,
                               PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `invoice_items`
--

DROP TABLE IF EXISTS `invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_items` (
                                 `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                 `invoice_id` bigint(20) unsigned DEFAULT NULL,
                                 `invoice_type_id` bigint(20) unsigned DEFAULT NULL,
                                 `amount` decimal(12,2) DEFAULT NULL,
                                 `tax_amount` decimal(12,2) NOT NULL DEFAULT '0.00',
                                 `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
                                 `created_at` timestamp NULL DEFAULT NULL,
                                 `updated_at` timestamp NULL DEFAULT NULL,
                                 `deleted_at` timestamp NULL DEFAULT NULL,
                                 PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `invoice_recurring_setting_items`
--

DROP TABLE IF EXISTS `invoice_recurring_setting_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_recurring_setting_items` (
                                                   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                                   `invoice_recurring_setting_id` bigint(20) unsigned DEFAULT NULL,
                                                   `invoice_type_id` bigint(20) unsigned DEFAULT NULL,
                                                   `amount` decimal(12,2) NOT NULL DEFAULT '0.00',
                                                   `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
                                                   `created_at` timestamp NULL DEFAULT NULL,
                                                   `updated_at` timestamp NULL DEFAULT NULL,
                                                   `deleted_at` timestamp NULL DEFAULT NULL,
                                                   PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `invoice_recurring_settings`
--

DROP TABLE IF EXISTS `invoice_recurring_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_recurring_settings` (
                                              `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                              `tenant_id` bigint(20) unsigned NOT NULL,
                                              `owner_user_id` bigint(20) unsigned DEFAULT NULL,
                                              `property_id` bigint(20) unsigned NOT NULL,
                                              `property_unit_id` bigint(20) unsigned NOT NULL,
                                              `start_date` datetime NOT NULL DEFAULT '2024-01-01 06:00:00',
                                              `recurring_type` tinyint(4) NOT NULL DEFAULT '1',
                                              `cycle_day` int(11) DEFAULT NULL,
                                              `due_day_after` int(11) NOT NULL DEFAULT '0',
                                              `invoice_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                              `amount` decimal(12,2) NOT NULL DEFAULT '0.00',
                                              `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0=deactivate,1=active',
                                              `created_at` timestamp NULL DEFAULT NULL,
                                              `updated_at` timestamp NULL DEFAULT NULL,
                                              `deleted_at` timestamp NULL DEFAULT NULL,
                                              PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `invoice_types`
--

DROP TABLE IF EXISTS `invoice_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_types` (
                                 `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                 `owner_user_id` bigint(20) unsigned DEFAULT NULL,
                                 `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                                 `tax` decimal(12,3) NOT NULL DEFAULT '0.000',
                                 `status` tinyint(4) DEFAULT '1' COMMENT '0=deactivate,1=active',
                                 `created_at` timestamp NULL DEFAULT NULL,
                                 `updated_at` timestamp NULL DEFAULT NULL,
                                 `deleted_at` timestamp NULL DEFAULT NULL,
                                 PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoices` (
                            `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                            `tenant_id` bigint(20) unsigned NOT NULL,
                            `owner_user_id` bigint(20) unsigned DEFAULT NULL,
                            `invoice_recurring_setting_id` bigint(20) unsigned DEFAULT NULL,
                            `property_id` bigint(20) unsigned NOT NULL,
                            `property_unit_id` bigint(20) unsigned NOT NULL,
                            `order_id` bigint(20) unsigned DEFAULT NULL,
                            `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                            `invoice_no` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                            `month` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                            `due_date` date NOT NULL,
                            `amount` decimal(12,2) DEFAULT NULL,
                            `tax_amount` decimal(12,2) NOT NULL DEFAULT '0.00',
                            `late_fee` decimal(12,2) DEFAULT '0.00',
                            `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0=pending,1=paid,2=overdue',
                            `created_at` timestamp NULL DEFAULT NULL,
                            `updated_at` timestamp NULL DEFAULT NULL,
                            `deleted_at` timestamp NULL DEFAULT NULL,
                            PRIMARY KEY (`id`),
                            UNIQUE KEY `invoices_invoice_no_unique` (`invoice_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `kyc_configs`
--

DROP TABLE IF EXISTS `kyc_configs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kyc_configs` (
                               `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                               `tenant_id` bigint(20) unsigned DEFAULT NULL,
                               `owner_user_id` bigint(20) unsigned DEFAULT NULL,
                               `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                               `details` text COLLATE utf8mb4_unicode_ci NOT NULL,
                               `is_both` tinyint(4) NOT NULL DEFAULT '0',
                               `status` tinyint(4) NOT NULL DEFAULT '1',
                               `created_at` timestamp NULL DEFAULT NULL,
                               `updated_at` timestamp NULL DEFAULT NULL,
                               `deleted_at` timestamp NULL DEFAULT NULL,
                               PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `kyc_verifications`
--

DROP TABLE IF EXISTS `kyc_verifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kyc_verifications` (
                                     `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                     `tenant_id` bigint(20) unsigned NOT NULL,
                                     `owner_user_id` bigint(20) unsigned DEFAULT NULL,
                                     `kyc_config_id` bigint(20) unsigned NOT NULL,
                                     `front_id` bigint(20) unsigned DEFAULT NULL,
                                     `back_id` bigint(20) unsigned DEFAULT NULL,
                                     `status` tinyint(4) NOT NULL DEFAULT '2' COMMENT 'accepted, pending, rejected',
                                     `reason` text COLLATE utf8mb4_unicode_ci,
                                     `created_at` timestamp NULL DEFAULT NULL,
                                     `updated_at` timestamp NULL DEFAULT NULL,
                                     `deleted_at` timestamp NULL DEFAULT NULL,
                                     PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `languages` (
                             `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                             `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                             `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                             `font_id` int(11) DEFAULT NULL,
                             `icon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                             `rtl` tinyint(4) NOT NULL DEFAULT '0',
                             `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '1=Active,0=Disable',
                             `default` tinyint(4) NOT NULL DEFAULT '0' COMMENT '1=yes,0=no',
                             `created_at` timestamp NULL DEFAULT NULL,
                             `updated_at` timestamp NULL DEFAULT NULL,
                             `deleted_at` timestamp NULL DEFAULT NULL,
                             PRIMARY KEY (`id`),
                             UNIQUE KEY `languages_name_unique` (`name`),
                             UNIQUE KEY `languages_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `listing_contacts`
--

DROP TABLE IF EXISTS `listing_contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `listing_contacts` (
                                    `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                    `owner_user_id` bigint(20) unsigned DEFAULT NULL,
                                    `listing_id` bigint(20) unsigned DEFAULT NULL,
                                    `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                    `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                    `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                    `profession` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                    `details` text COLLATE utf8mb4_unicode_ci,
                                    `reply` text COLLATE utf8mb4_unicode_ci,
                                    `status` tinyint(4) NOT NULL DEFAULT '1',
                                    `created_at` timestamp NULL DEFAULT NULL,
                                    `updated_at` timestamp NULL DEFAULT NULL,
                                    `deleted_at` timestamp NULL DEFAULT NULL,
                                    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `listing_images`
--

DROP TABLE IF EXISTS `listing_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `listing_images` (
                                  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                  `owner_user_id` bigint(20) unsigned DEFAULT NULL,
                                  `listing_id` bigint(20) unsigned NOT NULL,
                                  `file_id` bigint(20) unsigned NOT NULL,
                                  `created_at` timestamp NULL DEFAULT NULL,
                                  `updated_at` timestamp NULL DEFAULT NULL,
                                  `deleted_at` timestamp NULL DEFAULT NULL,
                                  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `listing_information`
--

DROP TABLE IF EXISTS `listing_information`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `listing_information` (
                                       `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                       `owner_user_id` bigint(20) unsigned DEFAULT NULL,
                                       `listing_id` bigint(20) unsigned DEFAULT NULL,
                                       `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                       `distance` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                       `contact_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                       `details` longtext COLLATE utf8mb4_unicode_ci,
                                       `file_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                       `created_at` timestamp NULL DEFAULT NULL,
                                       `updated_at` timestamp NULL DEFAULT NULL,
                                       `deleted_at` timestamp NULL DEFAULT NULL,
                                       PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
--
-- Table structure for table `listings`
--

DROP TABLE IF EXISTS `listings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `listings` (
                            `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                            `owner_user_id` bigint(20) unsigned DEFAULT NULL,
                            `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                            `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                            `address` tinytext COLLATE utf8mb4_unicode_ci,
                            `latitude` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                            `longitude` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                            `country` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                            `state` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                            `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                            `zip_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                            `price` decimal(12,2) NOT NULL DEFAULT '0.00',
                            `price_duration_type` tinyint(4) NOT NULL DEFAULT '1',
                            `bed_room` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                            `bath_room` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                            `kitchen_room` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                            `dining_room` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                            `living_room` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                            `storage_room` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                            `other_room` text COLLATE utf8mb4_unicode_ci,
                            `interior` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                            `type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                            `amenities` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                            `advantage` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                            `details` longtext COLLATE utf8mb4_unicode_ci,
                            `status` tinyint(4) NOT NULL DEFAULT '0',
                            `created_at` timestamp NULL DEFAULT NULL,
                            `updated_at` timestamp NULL DEFAULT NULL,
                            `deleted_at` timestamp NULL DEFAULT NULL,
                            PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mail_histories`
--

DROP TABLE IF EXISTS `mail_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mail_histories` (
                                  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                  `owner_user_id` bigint(20) unsigned NOT NULL,
                                  `host` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                  `subject` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                  `message` text COLLATE utf8mb4_unicode_ci,
                                  `status` tinyint(4) NOT NULL DEFAULT '1',
                                  `user_id` bigint(20) unsigned DEFAULT NULL,
                                  `date` datetime DEFAULT NULL,
                                  `error` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                  `created_at` timestamp NULL DEFAULT NULL,
                                  `updated_at` timestamp NULL DEFAULT NULL,
                                  `deleted_at` timestamp NULL DEFAULT NULL,
                                  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `maintainers`
--

DROP TABLE IF EXISTS `maintainers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `maintainers` (
                               `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                               `user_id` bigint(20) unsigned NOT NULL,
                               `property_id` bigint(20) unsigned NOT NULL,
                               `owner_user_id` bigint(20) unsigned DEFAULT NULL,
                               `created_at` timestamp NULL DEFAULT NULL,
                               `updated_at` timestamp NULL DEFAULT NULL,
                               `deleted_at` timestamp NULL DEFAULT NULL,
                               PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `maintenance_issues`
--

DROP TABLE IF EXISTS `maintenance_issues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `maintenance_issues` (
                                      `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                      `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                                      `owner_user_id` bigint(20) unsigned DEFAULT NULL,
                                      `status` tinyint(4) NOT NULL DEFAULT '1',
                                      `created_at` timestamp NULL DEFAULT NULL,
                                      `updated_at` timestamp NULL DEFAULT NULL,
                                      `deleted_at` timestamp NULL DEFAULT NULL,
                                      PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `maintenance_requests`
--

DROP TABLE IF EXISTS `maintenance_requests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `maintenance_requests` (
                                        `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                        `created_by` bigint unsigned DEFAULT NULL,
                                        `request_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                        `property_id` bigint UNSIGNED NOT NULL,
                                        `owner_user_id` bigint UNSIGNED DEFAULT NULL,
                                        `unit_id` bigint UNSIGNED DEFAULT NULL,
                                        `issue_id` bigint UNSIGNED NOT NULL,
                                        `details` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
                                        `status` tinyint NOT NULL DEFAULT '3',
                                        `attach_id` bigint UNSIGNED DEFAULT NULL,
                                        `invoice_id` bigint UNSIGNED DEFAULT NULL,
                                        `amount` decimal(12,2) NOT NULL DEFAULT '0.00',
                                        `created_date` date DEFAULT NULL,
                                        `resolved_date` date DEFAULT NULL,
                                        `created_at` timestamp NULL DEFAULT NULL,
                                        `updated_at` timestamp NULL DEFAULT NULL,
                                        `deleted_at` timestamp NULL DEFAULT NULL,
                                        PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `messages` (
                            `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                            `first_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                            `last_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                            `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                            `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                            `subject` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                            `is_view` tinyint(1) NOT NULL DEFAULT '0',
                            `message` tinytext COLLATE utf8mb4_unicode_ci,
                            `reply` tinytext COLLATE utf8mb4_unicode_ci,
                            `created_at` timestamp NULL DEFAULT NULL,
                            `updated_at` timestamp NULL DEFAULT NULL,
                            `deleted_at` timestamp NULL DEFAULT NULL,
                            PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `metas`
--

DROP TABLE IF EXISTS `metas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `metas` (
                         `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                         `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                         `page_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                         `meta_title` mediumtext COLLATE utf8mb4_unicode_ci,
                         `meta_description` mediumtext COLLATE utf8mb4_unicode_ci,
                         `meta_keyword` mediumtext COLLATE utf8mb4_unicode_ci,
                         `created_at` timestamp NULL DEFAULT NULL,
                         `updated_at` timestamp NULL DEFAULT NULL,
                         `deleted_at` timestamp NULL DEFAULT NULL,
                         PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
                              `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
                              `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                              `batch` int(11) NOT NULL,
                              PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=84 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `notice_boards`
--

DROP TABLE IF EXISTS `notice_boards`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notice_boards` (
                                 `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                 `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                                 `owner_user_id` bigint(20) unsigned DEFAULT NULL,
                                 `details` text COLLATE utf8mb4_unicode_ci,
                                 `start_date` date NOT NULL,
                                 `end_date` date NOT NULL,
                                 `property_id` bigint(20) unsigned DEFAULT NULL,
                                 `unit_id` bigint(20) unsigned DEFAULT NULL,
                                 `property_all` tinyint(4) NOT NULL DEFAULT '0',
                                 `unit_all` tinyint(4) NOT NULL DEFAULT '0',
                                 `created_at` timestamp NULL DEFAULT NULL,
                                 `updated_at` timestamp NULL DEFAULT NULL,
                                 `deleted_at` timestamp NULL DEFAULT NULL,
                                 PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `notice_user`
--

DROP TABLE IF EXISTS `notice_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notice_user` (
                               `notice_id` bigint(20) unsigned NOT NULL,
                               `user_id` bigint(20) unsigned NOT NULL,
                               `status` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `notifications`
--

DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notifications` (
                                 `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                 `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                                 `body` text COLLATE utf8mb4_unicode_ci,
                                 `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                 `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                 `is_seen` tinyint(4) NOT NULL DEFAULT '0',
                                 `user_id` bigint(20) unsigned DEFAULT NULL,
                                 `sender_id` bigint(20) unsigned DEFAULT NULL,
                                 `created_at` timestamp NULL DEFAULT NULL,
                                 `updated_at` timestamp NULL DEFAULT NULL,
                                 PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `oauth_access_tokens`
--

DROP TABLE IF EXISTS `oauth_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_access_tokens` (
                                       `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
                                       `user_id` bigint(20) unsigned DEFAULT NULL,
                                       `client_id` bigint(20) unsigned NOT NULL,
                                       `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                       `scopes` text COLLATE utf8mb4_unicode_ci,
                                       `revoked` tinyint(1) NOT NULL,
                                       `created_at` timestamp NULL DEFAULT NULL,
                                       `updated_at` timestamp NULL DEFAULT NULL,
                                       `expires_at` datetime DEFAULT NULL,
                                       PRIMARY KEY (`id`),
                                       KEY `oauth_access_tokens_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `oauth_auth_codes`
--

DROP TABLE IF EXISTS `oauth_auth_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_auth_codes` (
                                    `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
                                    `user_id` bigint(20) unsigned NOT NULL,
                                    `client_id` bigint(20) unsigned NOT NULL,
                                    `scopes` text COLLATE utf8mb4_unicode_ci,
                                    `revoked` tinyint(1) NOT NULL,
                                    `expires_at` datetime DEFAULT NULL,
                                    PRIMARY KEY (`id`),
                                    KEY `oauth_auth_codes_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `oauth_clients`
--

DROP TABLE IF EXISTS `oauth_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_clients` (
                                 `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                 `user_id` bigint(20) unsigned DEFAULT NULL,
                                 `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                                 `secret` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                 `provider` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                 `redirect` text COLLATE utf8mb4_unicode_ci NOT NULL,
                                 `personal_access_client` tinyint(1) NOT NULL,
                                 `password_client` tinyint(1) NOT NULL,
                                 `revoked` tinyint(1) NOT NULL,
                                 `created_at` timestamp NULL DEFAULT NULL,
                                 `updated_at` timestamp NULL DEFAULT NULL,
                                 PRIMARY KEY (`id`),
                                 KEY `oauth_clients_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `oauth_personal_access_clients`
--

DROP TABLE IF EXISTS `oauth_personal_access_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_personal_access_clients` (
                                                 `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                                 `client_id` bigint(20) unsigned NOT NULL,
                                                 `created_at` timestamp NULL DEFAULT NULL,
                                                 `updated_at` timestamp NULL DEFAULT NULL,
                                                 PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `oauth_refresh_tokens`
--

DROP TABLE IF EXISTS `oauth_refresh_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_refresh_tokens` (
                                        `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
                                        `access_token_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
                                        `revoked` tinyint(1) NOT NULL,
                                        `expires_at` datetime DEFAULT NULL,
                                        PRIMARY KEY (`id`),
                                        KEY `oauth_refresh_tokens_access_token_id_index` (`access_token_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orders` (
                          `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                          `payment_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                          `transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                          `user_id` bigint(20) unsigned NOT NULL,
                          `invoice_id` bigint(20) unsigned DEFAULT NULL,
                          `amount` double(8,2) DEFAULT '0.00',
                          `tax_amount` double(8,2) DEFAULT NULL,
                          `tax_percentage` double(8,2) DEFAULT NULL,
                          `system_currency` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                          `gateway_id` bigint(20) unsigned NOT NULL,
                          `gateway_currency` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                          `conversion_rate` double(8,2) DEFAULT '1.00',
                          `subtotal` double(8,2) NOT NULL DEFAULT '0.00',
                          `total` double(8,2) DEFAULT '0.00',
                          `transaction_amount` double(8,2) DEFAULT '0.00',
                          `payment_status` tinyint(4) DEFAULT '0' COMMENT '0=pending, 1=paid, 2=cancelled',
                          `bank_id` tinyint(4) DEFAULT NULL,
                          `bank_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                          `bank_account_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                          `deposit_by` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                          `deposit_slip_id` bigint(20) unsigned DEFAULT NULL,
                          `created_at` timestamp NULL DEFAULT NULL,
                          `updated_at` timestamp NULL DEFAULT NULL,
                          `deleted_at` timestamp NULL DEFAULT NULL,
                          PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `owner_packages`
--

DROP TABLE IF EXISTS `owner_packages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `owner_packages` (
                                  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                  `user_id` bigint(20) unsigned NOT NULL,
                                  `package_id` bigint(20) unsigned NOT NULL,
                                  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                                  `max_maintainer` int(11) NOT NULL DEFAULT '0',
                                  `max_property` int(11) NOT NULL DEFAULT '0',
                                  `max_unit` int(11) NOT NULL DEFAULT '0',
                                  `max_tenant` int(11) NOT NULL DEFAULT '0',
                                  `max_invoice` int(11) NOT NULL DEFAULT '0',
                                  `max_auto_invoice` int(11) NOT NULL DEFAULT '0',
                                  `ticket_support` tinyint(4) NOT NULL DEFAULT '0',
                                  `notice_support` tinyint(4) NOT NULL DEFAULT '0',
                                  `monthly_price` decimal(12,2) NOT NULL DEFAULT '0.00',
                                  `yearly_price` decimal(12,2) NOT NULL DEFAULT '0.00',
                                  `per_yearly_price` decimal(12,2) NOT NULL DEFAULT '0.00',
                                  `per_monthly_price` decimal(12,2) NOT NULL DEFAULT '0.00',
                                  `start_date` datetime NOT NULL,
                                  `end_date` datetime NOT NULL,
                                  `order_id` bigint(20) unsigned DEFAULT NULL,
                                  `status` tinyint(4) NOT NULL DEFAULT '0',
                                  `is_trail` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'default for 1 , not default for 0',
                                  `created_at` timestamp NULL DEFAULT NULL,
                                  `updated_at` timestamp NULL DEFAULT NULL,
                                  `deleted_at` timestamp NULL DEFAULT NULL,
                                  `package_type` tinyint(4) NOT NULL DEFAULT '0',
                                  `quantity` tinyint(4) NOT NULL DEFAULT '0',
                                  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `owners`
--

DROP TABLE IF EXISTS `owners`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `owners` (
                          `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                          `user_id` bigint(20) unsigned NOT NULL,
                          `status` tinyint(4) NOT NULL DEFAULT '1',
                          `created_at` timestamp NULL DEFAULT NULL,
                          `updated_at` timestamp NULL DEFAULT NULL,
                          `deleted_at` timestamp NULL DEFAULT NULL,
                          `print_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                          `print_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                          `print_contact` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                          `logo_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                          PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `packages`
--

DROP TABLE IF EXISTS `packages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `packages` (
                      `id` bigint unsigned NOT NULL AUTO_INCREMENT,
                      `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
                      `description` longtext COLLATE utf8mb4_unicode_ci,
                      `slug` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
                      `max_maintainer` int NOT NULL DEFAULT '0',
                      `max_property` int NOT NULL DEFAULT '0',
                      `max_unit` int NOT NULL DEFAULT '0',
                      `max_tenant` int NOT NULL DEFAULT '0',
                      `max_invoice` int NOT NULL DEFAULT '0',
                      `max_auto_invoice` int NOT NULL DEFAULT '0',
                      `ticket_support` tinyint NOT NULL DEFAULT '0',
                      `notice_support` tinyint NOT NULL DEFAULT '0',
                      `monthly_price` decimal(12,2) NOT NULL DEFAULT '0.00',
                      `yearly_price` decimal(12,2) NOT NULL DEFAULT '0.00',
                      `per_yearly_price` decimal(12,2) NOT NULL DEFAULT '0.00',
                      `per_monthly_price` decimal(12,2) NOT NULL DEFAULT '0.00',
                      `type` tinyint NOT NULL DEFAULT '0',
                      `status` tinyint NOT NULL DEFAULT '0' COMMENT 'active for 1 , deactivate for 0',
                      `is_default` tinyint NOT NULL DEFAULT '0' COMMENT 'default for 1 , not default for 0',
                      `is_trail` tinyint NOT NULL DEFAULT '0' COMMENT 'default for 1 , not default for 0',
                      `created_at` timestamp NULL DEFAULT NULL,
                      `updated_at` timestamp NULL DEFAULT NULL,
                      `deleted_at` timestamp NULL DEFAULT NULL,
                      `others` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
                      PRIMARY KEY (`id`),
                      UNIQUE KEY `packages_name_unique` (`name`),
                      UNIQUE KEY `packages_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `packages`
--


--
-- Table structure for table `blogs`
--

DROP TABLE IF EXISTS `blogs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `blogs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `details` longtext COLLATE utf8mb4_unicode_ci,
  `publish_date` datetime DEFAULT NULL,
  `blog_category_id` bigint unsigned DEFAULT NULL,
  `status` tinyint NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs`
--
--
-- Table structure for table `blog_categories`
--

DROP TABLE IF EXISTS `blog_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `blog_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blog_categories`
--

--
-- Table structure for table `password_resets`
--

DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
                                   `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                                   `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                                   `created_at` timestamp NULL DEFAULT NULL,
                                   KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `personal_access_tokens` (
                                          `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                          `tokenable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                                          `tokenable_id` bigint(20) unsigned NOT NULL,
                                          `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                                          `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
                                          `abilities` text COLLATE utf8mb4_unicode_ci,
                                          `last_used_at` timestamp NULL DEFAULT NULL,
                                          `expires_at` timestamp NULL DEFAULT NULL,
                                          `created_at` timestamp NULL DEFAULT NULL,
                                          `updated_at` timestamp NULL DEFAULT NULL,
                                          PRIMARY KEY (`id`),
                                          UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
                                          KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `properties`
--

DROP TABLE IF EXISTS `properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `properties` (
                              `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                              `owner_user_id` bigint(20) unsigned DEFAULT NULL,
                              `property_type` tinyint(4) NOT NULL COMMENT '1=Own, 2=Lease',
                              `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                              `number_of_unit` int(11) NOT NULL,
                              `description` text COLLATE utf8mb4_unicode_ci,
                              `thumbnail_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                              `unit_type` tinyint(4) DEFAULT NULL COMMENT '1=Single, 2=Multiple',
                              `status` tinyint(4) DEFAULT '4' COMMENT '1=Active, 2=Inactive, 3=Cancelled, 4=Draft',
                              `thumbnail_image_id` bigint(20) unsigned DEFAULT NULL,
                              `deleted_at` timestamp NULL DEFAULT NULL,
                              `created_at` timestamp NULL DEFAULT NULL,
                              `updated_at` timestamp NULL DEFAULT NULL,
                              `maintainer_id` bigint(20) unsigned DEFAULT NULL,
                              PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `property_details`
--

DROP TABLE IF EXISTS `property_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `property_details` (
                                    `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                    `property_id` bigint(20) unsigned NOT NULL,
                                    `lease_amount` decimal(12,2) DEFAULT '0.00',
                                    `lease_start_date` date DEFAULT NULL,
                                    `lease_end_date` date DEFAULT NULL,
                                    `country_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                    `state_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                    `city_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                    `zip_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                    `address` text COLLATE utf8mb4_unicode_ci,
                                    `map_link` mediumtext COLLATE utf8mb4_unicode_ci,
                                    `deleted_at` timestamp NULL DEFAULT NULL,
                                    `created_at` timestamp NULL DEFAULT NULL,
                                    `updated_at` timestamp NULL DEFAULT NULL,
                                    PRIMARY KEY (`id`),
                                    KEY `property_details_property_id_foreign` (`property_id`),
                                    CONSTRAINT `property_details_property_id_foreign` FOREIGN KEY (`property_id`) REFERENCES `properties` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `property_images`
--

DROP TABLE IF EXISTS `property_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `property_images` (
                                   `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                   `property_id` bigint(20) unsigned NOT NULL,
                                   `file_id` bigint(20) unsigned NOT NULL,
                                   `created_at` timestamp NULL DEFAULT NULL,
                                   `updated_at` timestamp NULL DEFAULT NULL,
                                   `deleted_at` timestamp NULL DEFAULT NULL,
                                   PRIMARY KEY (`id`),
                                   KEY `property_images_property_id_foreign` (`property_id`),
                                   CONSTRAINT `property_images_property_id_foreign` FOREIGN KEY (`property_id`) REFERENCES `properties` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `property_units`
--

DROP TABLE IF EXISTS `property_units`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `property_units` (
                                  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                  `property_id` bigint(20) unsigned NOT NULL,
                                  `unit_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                                  `bedroom` int(11) NOT NULL,
                                  `bath` int(11) NOT NULL,
                                  `kitchen` int(11) NOT NULL,
                                  `general_rent` decimal(12,2) DEFAULT '0.00',
                                  `security_deposit` decimal(12,2) DEFAULT '0.00',
                                  `security_deposit_type` tinyint(4) NOT NULL DEFAULT '0',
                                  `late_fee` decimal(12,2) DEFAULT '0.00',
                                  `late_fee_type` tinyint(4) NOT NULL DEFAULT '0',
                                  `incident_receipt` decimal(12,2) DEFAULT '0.00',
                                  `rent_type` tinyint(4) DEFAULT NULL COMMENT '1=monthly,2=yearly,3=custom',
                                  `monthly_due_day` int(11) DEFAULT NULL,
                                  `yearly_due_day` int(11) DEFAULT NULL,
                                  `lease_start_date` date DEFAULT NULL,
                                  `lease_end_date` date DEFAULT NULL,
                                  `lease_payment_due_date` date DEFAULT NULL,
                                  `deleted_at` timestamp NULL DEFAULT NULL,
                                  `created_at` timestamp NULL DEFAULT NULL,
                                  `updated_at` timestamp NULL DEFAULT NULL,
                                  `description` tinytext COLLATE utf8mb4_unicode_ci,
                                  `square_feet` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                  `amenities` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                  `parking` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                  `condition` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                  PRIMARY KEY (`id`),
                                  KEY `property_units_property_id_foreign` (`property_id`),
                                  CONSTRAINT `property_units_property_id_foreign` FOREIGN KEY (`property_id`) REFERENCES `properties` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `settings` (
                            `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                            `option_key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                            `option_value` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                            `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                            `created_at` timestamp NULL DEFAULT NULL,
                            `updated_at` timestamp NULL DEFAULT NULL,
                            `deleted_at` timestamp NULL DEFAULT NULL,
                            PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sms_histories`
--

DROP TABLE IF EXISTS `sms_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sms_histories` (
                                 `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                 `owner_user_id` bigint(20) unsigned NOT NULL,
                                 `api` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                 `phone_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                 `message` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                 `status` tinyint(4) NOT NULL DEFAULT '1',
                                 `user_id` bigint(20) unsigned DEFAULT NULL,
                                 `date` datetime DEFAULT NULL,
                                 `error` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                 `created_at` timestamp NULL DEFAULT NULL,
                                 `updated_at` timestamp NULL DEFAULT NULL,
                                 `deleted_at` timestamp NULL DEFAULT NULL,
                                 PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `subscription_orders`
--

DROP TABLE IF EXISTS `subscription_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `subscription_orders` (
                                       `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                       `payment_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                       `transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                       `user_id` bigint(20) unsigned NOT NULL,
                                       `package_id` bigint(20) unsigned DEFAULT NULL,
                                       `duration_type` tinyint(4) NOT NULL DEFAULT '1',
                                       `amount` double(8,2) DEFAULT '0.00',
                                       `tax_amount` double(8,2) DEFAULT NULL,
                                       `tax_percentage` double(8,2) DEFAULT NULL,
                                       `system_currency` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                       `gateway_id` bigint(20) unsigned NOT NULL,
                                       `gateway_currency` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                       `conversion_rate` double(8,2) DEFAULT '1.00',
                                       `subtotal` double(8,2) NOT NULL DEFAULT '0.00',
                                       `total` double(8,2) DEFAULT '0.00',
                                       `transaction_amount` double(8,2) DEFAULT '0.00',
                                       `payment_status` tinyint(4) DEFAULT '0' COMMENT '0=pending, 1=paid, 2=cancelled',
                                       `bank_id` bigint(20) unsigned DEFAULT NULL,
                                       `bank_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                       `bank_account_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                       `deposit_by` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                       `deposit_slip_id` bigint(20) unsigned DEFAULT NULL,
                                       `created_at` timestamp NULL DEFAULT NULL,
                                       `updated_at` timestamp NULL DEFAULT NULL,
                                       `deleted_at` timestamp NULL DEFAULT NULL,
                                       `package_type` tinyint(4) NOT NULL DEFAULT '0',
                                       `quantity` int(11) NOT NULL DEFAULT '1',
                                       PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tax_settings`
--

DROP TABLE IF EXISTS `tax_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tax_settings` (
                                `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                `owner_user_id` bigint(20) unsigned NOT NULL,
                                `type` tinyint(4) NOT NULL DEFAULT '0',
                                `amount` decimal(12,2) NOT NULL DEFAULT '0.00',
                                `created_at` timestamp NULL DEFAULT NULL,
                                `updated_at` timestamp NULL DEFAULT NULL,
                                `deleted_at` timestamp NULL DEFAULT NULL,
                                PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tenancies`
--

DROP TABLE IF EXISTS `tenancies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tenancies` (
                             `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                             `data` json DEFAULT NULL,
                             `created_at` timestamp NULL DEFAULT NULL,
                             `updated_at` timestamp NULL DEFAULT NULL,
                             PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tenant_details`
--

DROP TABLE IF EXISTS `tenant_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tenant_details` (
                                  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                  `tenant_id` bigint(20) unsigned NOT NULL,
                                  `previous_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                  `previous_country_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                  `previous_state_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                  `previous_city_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                  `previous_zip_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                  `permanent_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                  `permanent_country_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                  `permanent_state_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                  `permanent_city_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                  `permanent_zip_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                  `created_at` timestamp NULL DEFAULT NULL,
                                  `updated_at` timestamp NULL DEFAULT NULL,
                                  `deleted_at` timestamp NULL DEFAULT NULL,
                                  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tenants`
--

DROP TABLE IF EXISTS `tenants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tenants` (
                           `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                           `user_id` bigint(20) unsigned NOT NULL,
                           `owner_user_id` bigint(20) unsigned DEFAULT NULL,
                           `job` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                           `image_id` bigint(20) unsigned DEFAULT NULL,
                           `age` int(11) DEFAULT NULL,
                           `family_member` int(11) NOT NULL,
                           `property_id` bigint(20) unsigned DEFAULT NULL,
                           `unit_id` bigint(20) unsigned DEFAULT NULL,
                           `rent_type` tinyint(4) NOT NULL DEFAULT '1',
                           `due_date` tinyint(4) DEFAULT NULL,
                           `lease_start_date` date DEFAULT NULL,
                           `lease_end_date` date DEFAULT NULL,
                           `general_rent` decimal(12,2) NOT NULL DEFAULT '0.00',
                           `security_deposit` decimal(12,2) NOT NULL DEFAULT '0.00',
                           `security_deposit_type` tinyint(4) NOT NULL DEFAULT '0',
                           `late_fee` decimal(12,2) NOT NULL DEFAULT '0.00',
                           `late_fee_type` tinyint(4) NOT NULL DEFAULT '0',
                           `incident_receipt` decimal(12,2) NOT NULL DEFAULT '0.00',
                           `status` tinyint(4) NOT NULL DEFAULT '3',
                           `close_refund_amount` decimal(12,2) NOT NULL DEFAULT '0.00',
                           `close_charge` decimal(12,2) NOT NULL DEFAULT '0.00',
                           `close_date` date DEFAULT NULL,
                           `close_reason` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                           `created_at` timestamp NULL DEFAULT NULL,
                           `updated_at` timestamp NULL DEFAULT NULL,
                           `deleted_at` timestamp NULL DEFAULT NULL,
                           PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `testimonials`
--

DROP TABLE IF EXISTS `testimonials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `testimonials` (
                                `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                                `designation` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                `comment` tinytext COLLATE utf8mb4_unicode_ci,
                                `star` tinyint(4) NOT NULL DEFAULT '5',
                                `status` tinyint(4) NOT NULL DEFAULT '0',
                                `created_at` timestamp NULL DEFAULT NULL,
                                `updated_at` timestamp NULL DEFAULT NULL,
                                `deleted_at` timestamp NULL DEFAULT NULL,
                                PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
--
-- Table structure for table `permissions`
--

INSERT INTO testimonials (id, name, designation, comment, star, status, created_at, updated_at, deleted_at) VALUES (1, 'Johnson Hernandez', 'Businessman', 'have tried a few AI copywriting apps but so far the best output amet have been on Zaiwriteai If you need to create quality content  quickly, I would thoroughly recommend Zaiwriteai literally lorem sity speechless from the originality of the content', 4, 1, '2023-04-03 05:08:04', '2023-04-03 05:16:41', null);
INSERT INTO testimonials (id, name, designation, comment, star, status, created_at, updated_at, deleted_at) VALUES (2, 'Angelina  Cali', 'Teacher', 'have tried a few AI copywriting apps but so far the best output amet have been on Zaiwriteai If you need to create quality content  quickly, I would thoroughly recommend Zaiwriteai literally lorem sity speechless from the originality of the content', 5, 1, '2023-04-03 05:08:08', '2023-04-03 05:15:37', null);
INSERT INTO testimonials (id, name, designation, comment, star, status, created_at, updated_at, deleted_at) VALUES (3, 'Indiana Jasper', 'Web developer', 'A property application is a digital platform that provides a range of services related to buying, selling, renting, or managing real estate properties. These applications typically allow users to search for properties based on location, price range, and o', 5, 1, '2023-04-03 05:19:20', '2023-04-03 05:19:20', null);
INSERT INTO testimonials (id, name, designation, comment, star, status, created_at, updated_at, deleted_at) VALUES (4, 'Linda Macy', 'Software Engineering', 'A property application is a mobile or web-based platform that helps users find, rent, or buy properties. These applications typically offer a range of features such as property search filters, real-time property availability updates, virtual property tour', 4, 1, '2023-04-03 05:21:07', '2023-04-03 05:21:07', null);
INSERT INTO testimonials (id, name, designation, comment, star, status, created_at, updated_at, deleted_at) VALUES (5, 'Winona . Zuri', 'Software engineering?', 'A property is a physical or intangible asset that a person or organization owns. Property can include land, buildings, vehicles, stocks, patents, and other valuable assets. Owning property can provide financial benefits, such as rental income, capital gai', 4, 1, '2023-04-03 05:35:52', '2023-04-03 05:35:52', null);


DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `permissions` (
                               `id` bigint unsigned NOT NULL AUTO_INCREMENT,
                               `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                               `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                               `created_at` timestamp NULL DEFAULT NULL,
                               `updated_at` timestamp NULL DEFAULT NULL,
                               PRIMARY KEY (`id`),
                               UNIQUE KEY `permissions_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `permissions`
--

INSERT INTO `permissions` VALUES (1,'Manage Property','web','2024-09-30 05:18:11','2024-09-30 05:18:11'),(2,'Manage Tenant','web','2024-09-30 05:18:11','2024-09-30 05:18:11'),(3,'Manage Billing','web','2024-09-30 05:18:11','2024-09-30 05:18:11'),(4,'Manage Expenses','web','2024-09-30 05:18:11','2024-09-30 05:18:11'),(5,'Manage Documents','web','2024-09-30 05:18:11','2024-09-30 05:18:11'),(6,'Manage Information','web','2024-09-30 05:18:11','2024-09-30 05:18:11'),(7,'Manage Listing','web','2024-09-30 05:18:11','2024-09-30 05:18:11'),(8,'Manage Maintains','web','2024-09-30 05:18:11','2024-09-30 05:18:11'),(9,'Manage Ticket','web','2024-09-30 05:18:11','2024-09-30 05:18:11'),(10,'Manage Noticeboard','web','2024-09-30 05:18:11','2024-09-30 05:18:11'),(11,'Manage Report','web','2024-09-30 05:18:11','2024-09-30 05:18:11'),(12,'Manage Settings','web','2024-09-30 05:18:11','2024-09-30 05:18:11'),(13,'Manage Bulk SMS/Mail','web','2024-09-30 05:18:11','2024-09-30 05:18:11'),(14,'Manage Agreement','web','2024-09-30 05:18:11','2024-09-30 05:18:11'),(15,'Manage Domain Config','web','2024-09-30 05:18:11','2024-09-30 05:18:11'),(16,'Manage Team','web','2024-09-30 05:18:11','2024-09-30 05:18:11'),(17,'Manage Subscription','web','2024-09-30 05:18:11','2024-09-30 05:18:11');

--
-- Table structure for table `ticket_replies`
--

DROP TABLE IF EXISTS `ticket_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ticket_replies` (
                                  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                  `ticket_id` bigint(20) unsigned NOT NULL,
                                  `user_id` int(10) unsigned NOT NULL,
                                  `reply` text COLLATE utf8mb4_unicode_ci NOT NULL,
                                  `created_at` timestamp NULL DEFAULT NULL,
                                  `updated_at` timestamp NULL DEFAULT NULL,
                                  `deleted_at` timestamp NULL DEFAULT NULL,
                                  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `ticket_topics`
--

DROP TABLE IF EXISTS `ticket_topics`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ticket_topics` (
                                 `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                 `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                                 `owner_user_id` bigint(20) unsigned DEFAULT NULL,
                                 `status` tinyint(4) DEFAULT '1' COMMENT '0=deactivate,1=active',
                                 `created_at` timestamp NULL DEFAULT NULL,
                                 `updated_at` timestamp NULL DEFAULT NULL,
                                 `deleted_at` timestamp NULL DEFAULT NULL,
                                 PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tickets`
--

DROP TABLE IF EXISTS `tickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tickets` (
                           `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                           `user_id` bigint(20) unsigned NOT NULL,
                           `property_id` bigint(20) unsigned NOT NULL,
                           `owner_user_id` bigint(20) unsigned DEFAULT NULL,
                           `unit_id` bigint(20) unsigned DEFAULT NULL,
                           `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                           `details` text COLLATE utf8mb4_unicode_ci NOT NULL,
                           `topic_id` bigint(20) unsigned NOT NULL,
                           `status` tinyint(4) NOT NULL DEFAULT '1',
                           `ticket_no` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                           `created_at` timestamp NULL DEFAULT NULL,
                           `updated_at` timestamp NULL DEFAULT NULL,
                           `deleted_at` timestamp NULL DEFAULT NULL,
                           PRIMARY KEY (`id`),
                           UNIQUE KEY `tickets_ticket_no_unique` (`ticket_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `transactions`
--

DROP TABLE IF EXISTS `transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transactions` (
                                `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                                `user_id` bigint(20) unsigned NOT NULL,
                                `total_amount` decimal(12,2) NOT NULL DEFAULT '0.00',
                                `txn_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
                                `payment_method` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
                                `currency` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
                                `payment_details` longtext COLLATE utf8mb4_unicode_ci,
                                `payment_time` datetime DEFAULT NULL,
                                `status` enum('initiate','pending','completed','cancelled') COLLATE utf8mb4_unicode_ci NOT NULL,
                                `created_at` timestamp NULL DEFAULT NULL,
                                `updated_at` timestamp NULL DEFAULT NULL,
                                `deleted_at` timestamp NULL DEFAULT NULL,
                                PRIMARY KEY (`id`),
                                UNIQUE KEY `transactions_txn_id_unique` (`txn_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
                         `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                         `first_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                         `last_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                         `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                         `email_verified_at` timestamp NULL DEFAULT NULL,
                         `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                         `contact_number` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                         `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Active = true, Inactive = false',
                         `created_by` bigint(20) DEFAULT NULL,
                         `role` int(11) NOT NULL DEFAULT '1',
                         `owner_user_id` bigint(20) unsigned DEFAULT NULL,
                         `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                         `verify_token` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                         `otp` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                         `otp_expire` datetime DEFAULT NULL,
                         `last_seen` datetime NOT NULL DEFAULT '2025-07-13 10:48:24',
                         `deleted_at` timestamp NULL DEFAULT NULL,
                         `created_at` timestamp NULL DEFAULT NULL,
                         `updated_at` timestamp NULL DEFAULT NULL,
                         `date_of_birth` date DEFAULT NULL,
                         `nid_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                         PRIMARY KEY (`id`),
                         UNIQUE KEY `users_email_unique` (`email`),
                         UNIQUE KEY `users_contact_number_unique` (`contact_number`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

INSERT INTO `currencies` (id, currency_code, symbol, currency_placement, current_currency, created_at, updated_at, deleted_at) VALUES(1, 'USD', '$', 'before', 1, '2023-02-02 14:17:04', '2023-02-02 14:17:04', NULL),(2, 'BDT', '৳', 'before', 0, '2023-02-02 14:17:04', '2023-02-02 14:17:04', NULL),(3, 'INR', '₹', 'before', 0, '2023-02-02 14:17:04', '2023-02-02 14:17:04', NULL),(4, 'GBP', '£', 'after', 0, '2023-02-02 14:17:04', '2023-02-02 14:17:04', NULL),(5, 'MXN', '$', 'before', 0, '2023-02-02 14:17:04', '2023-02-02 14:17:04', NULL),(6, 'SAR', 'SR', 'before', 0, '2023-02-02 14:17:04', '2023-02-02 14:17:04', NULL);
INSERT INTO `file_managers` (`id`, `folder_name`, `file_name`, `file_size`, `origin_type`, `origin_id`, `created_at`, `updated_at`, `deleted_at`) VALUES(1, 'files/Gateway', 'paypal.png', NULL, 'App\\Models\\Gateway', 1, NULL, NULL, NULL),(2, 'files/Gateway', 'stripe.png', NULL, 'App\\Models\\Gateway', 2, NULL, NULL, NULL),(3, 'files/Gateway', 'razorpay.png', NULL, 'App\\Models\\Gateway', 3, NULL, NULL, NULL),(4, 'files/Gateway', 'instamojo.png', NULL, 'App\\Models\\Gateway', 4, NULL, NULL, NULL),(5, 'files/Gateway', 'mollie.png', NULL, 'App\\Models\\Gateway', 5, NULL, NULL, NULL),(6, 'files/Gateway', 'paystack.png', NULL, 'App\\Models\\Gateway', 6, NULL, NULL, NULL),(7, 'files/Gateway', 'sslcommerz.png', NULL, 'App\\Models\\Gateway', 7, NULL, NULL, NULL),(8, 'files/Gateway', 'flutterwave.png', NULL, 'App\\Models\\Gateway', 8, NULL, NULL, NULL),(9, 'files/Gateway', 'mercadopago.png', NULL, 'App\\Models\\Gateway', 9, NULL, NULL, NULL),(10, 'files/Gateway', 'bank.png', NULL, 'App\\Models\\Gateway', 10, NULL, NULL, NULL);
INSERT INTO `gateways` (id, owner_user_id, title, slug, image, status, mode, url, `key`, secret, created_at, updated_at, deleted_at)
VALUES
    (1, 2, 'Paypal', 'paypal', 'assets/images/gateway-icon/paypal.png', 1, 2, '', '', '', NULL, NULL, NULL),
    (2, 2, 'Stripe', 'stripe', 'assets/images/gateway-icon/stripe.png', 1, 2, '', '', '', NULL, NULL, NULL),
    (3, 2, 'Razorpay', 'razorpay', 'assets/images/gateway-icon/razorpay.png', 1, 2, '', '', '', NULL, NULL, NULL),
    (4, 2, 'Instamojo', 'instamojo', 'assets/images/gateway-icon/instamojo.png', 1, 2, '', '', '', NULL, NULL, NULL),
    (5, 2, 'Mollie', 'mollie', 'assets/images/gateway-icon/mollie.png', 1, 2, '', '', '', NULL, NULL, NULL),
    (6, 2, 'Coinbase', 'coinbase', 'assets/images/gateway-icon/coinbase.png', 1, 2, '', '', '', NULL, NULL, NULL),
    (7, 2, 'Paystack', 'paystack', 'assets/images/gateway-icon/paystack.png', 1, 2, '', '', '', NULL, NULL, NULL),
    (8, 2, 'Sslcommerz', 'sslcommerz', 'assets/images/gateway-icon/sslcommerz.png', 1, 2, '', '', '', NULL, NULL, NULL),
    (9, 2, 'Mercadopago', 'mercadopago', 'assets/images/gateway-icon/mercadopago.png', 1, 2, '', '', '', NULL, NULL, NULL),
    (10, 2, 'Flutterwave', 'flutterwave', 'assets/images/gateway-icon/flutterwave.png', 1, 2, '', '', '', NULL, NULL, NULL),
    (11, 2, 'Iyzipay', 'iyzipay', 'assets/images/gateway-icon/iyzipay.png', 1, 2, '', '', '', NULL, NULL, NULL),
    (12, 2, 'Bitpay', 'bitpay', 'assets/images/gateway-icon/bitpay.png', 1, 2, '', '', '', NULL, NULL, NULL),
    (13, 2, 'Zitopay', 'zitopay', 'assets/images/gateway-icon/zitopay.png', 1, 2, '', '', '', NULL, NULL, NULL),
    (14, 2, 'Binance', 'binance', 'assets/images/gateway-icon/binance.png', 1, 2, '', '', '', NULL, NULL, NULL),
    (15, 2, 'Paytm', 'paytm', 'assets/images/gateway-icon/paytm.png', 1, 2, '', '', '', NULL, NULL, NULL),
    (16, 2, 'Payhere', 'payhere', 'assets/images/gateway-icon/payhere.png', 1, 2, '', '', '', NULL, NULL, NULL),
    (17, 2, 'Maxicash', 'maxicash', 'assets/images/gateway-icon/maxicash.png', 1, 2, '', '', '', NULL, NULL, NULL),
    (18, 2, 'Cinetpay', 'cinetpay', 'assets/images/gateway-icon/cinetpay.png', 1, 2, '', '', '', NULL, NULL, NULL),
    (19, 2, 'Voguepay', 'voguepay', 'assets/images/gateway-icon/voguepay.png', 1, 2, '', '', '', NULL, NULL, NULL),
    (20, 2, 'Toyyibpay', 'toyyibpay', 'assets/images/gateway-icon/toyyibpay.png', 1, 2, '', '', '', NULL, NULL, NULL),
    (21, 2, 'Paymob', 'paymob', 'assets/images/gateway-icon/paymob.png', 1, 2, '', '', '', NULL, NULL, NULL),
    (22, 2, 'Authorize', 'authorize', 'assets/images/gateway-icon/authorize.png', 1, 2, '', '', '', NULL, NULL, NULL),
    (23, 2, 'Alipay', 'alipay', 'assets/images/gateway-icon/alipay.png', 1, 2, '', '', '', NULL, NULL, NULL),
    (24, 2, 'Bank', 'bank', 'assets/images/gateway-icon/bank.png', 1, 2, '', '', '', NULL, NULL, NULL),
    (25, 2, 'Cash', 'cash', 'assets/images/gateway-icon/cash.png', 1, 2, '', '', '', NULL, NULL, NULL);
INSERT INTO `gateway_currencies` (`id`, `gateway_id`, `currency`, `conversion_rate`, `created_at`, `updated_at`, `deleted_at`)
VALUES
    (1, 1, 'USD', '1.00', NULL, NULL, NULL),   -- Paypal
    (2, 2, 'USD', '1.00', NULL, NULL, NULL),   -- Stripe
    (3, 3, 'INR', '80.00', NULL, NULL, NULL),  -- Razorpay
    (4, 4, 'INR', '80.00', NULL, NULL, NULL),  -- Instamojo
    (5, 5, 'USD', '1.00', NULL, NULL, NULL),   -- Mollie
    (6, 6, 'USD', '1.00', NULL, NULL, NULL),   -- Coinbase
    (7, 7, 'NGN', '464.00', NULL, NULL, NULL), -- Paystack
    (8, 8, 'BDT', '100.00', NULL, NULL, NULL), -- Sslcommerz
    (9, 9, 'BRL', '5.00', NULL, NULL, NULL),   -- Mercadopago
    (10, 10, 'NGN', '464.00', NULL, NULL, NULL), -- Flutterwave
    (11, 11, 'INR', '80.00', NULL, NULL, NULL),  -- Iyzipay
    (12, 12, 'BTC', '0.0001', NULL, NULL, NULL), -- Bitpay
    (13, 13, 'USD', '1.00', NULL, NULL, NULL),   -- Zitopay
    (14, 14, 'USD', '1.00', NULL, NULL, NULL),   -- Binance
    (15, 15, 'INR', '80.00', NULL, NULL, NULL),  -- Paytm
    (16, 16, 'USD', '1.00', NULL, NULL, NULL),   -- Payhere
    (17, 17, 'USD', '1.00', NULL, NULL, NULL),   -- Maxicash
    (18, 18, 'USD', '1.00', NULL, NULL, NULL),   -- Cinetpay
    (19, 19, 'USD', '1.00', NULL, NULL, NULL),   -- Voguepay
    (20, 20, 'MYR', '4.50', NULL, NULL, NULL),   -- Toyyibpay
    (21, 21, 'EGP', '15.70', NULL, NULL, NULL),  -- Paymob
    (22, 22, 'USD', '1.00', NULL, NULL, NULL),   -- Authorize
    (23, 23, 'CNY', '6.50', NULL, NULL, NULL),   -- Alipay
    (24, 24, 'USD', '1.00', NULL, NULL, NULL),   -- Bank
    (25, 25, 'USD', '1.00', NULL, NULL, NULL);   -- Cash
INSERT INTO `languages` (id,name, code, icon, rtl, status, `default`, created_at, updated_at, deleted_at) VALUES(1, 'English', 'en', NULL, 0, 1, 1, '2023-02-02 14:17:04', '2023-02-02 14:17:04', NULL);
INSERT INTO users (id,first_name, last_name, email, email_verified_at, password, contact_number, status, created_by, `role`, owner_user_id, remember_token, deleted_at, created_at, updated_at) VALUES(1,'Mr', 'Admin', 'admin@gmail.com', '2023-02-02 17:34:12.000', '$2y$10$QJ79PGQOQgVetj9TVY/ow.qPyGm7nFD9N91y4Tl6pJy50C9wIFa/i', '01951973806', 1, NULL, 4, NULL, 'sT3YHYYmFXC71oWxpQgAnJ6SJgiUU7RHyo7HaJpUPr3ReTcrT7khlasBsVfi', NULL, NULL, '2023-02-04 13:54:59.000'),(2,'Mr', 'Owner', 'owner@gmail.com', '2023-02-02 17:34:12.000', '$2y$10$QJ79PGQOQgVetj9TVY/ow.qPyGm7nFD9N91y4Tl6pJy50C9wIFa/i', '01952973806', 1, NULL, 1, 2, '7O53ovKAFazO3hOh3Y0aXqAmhvncPe7FRCQCP8pldES3v3tBvAsLrynD67Pf', NULL, NULL, '2023-02-04 13:54:59.000');
INSERT INTO owners (user_id, status, created_at, updated_at, deleted_at) VALUES(2, 1, '2023-03-27 15:21:38.000', '2023-03-27 15:21:38.000', NULL);
INSERT INTO `settings` VALUES (1,'build_version','29',NULL,'2023-02-02 11:34:12','2023-02-02 11:34:12',NULL),(2,'current_version','4.5',NULL,'2023-02-02 11:34:12','2023-02-02 11:34:12',NULL),(3,'app_name','Zaiproty',NULL,'2023-02-02 17:51:06','2023-02-02 17:51:06',NULL),(4,'app_email','admin@zaiproty.com',NULL,'2023-02-02 17:51:06','2023-02-04 09:45:55',NULL),(5,'app_contact_number','551728282',NULL,'2023-02-02 17:51:06','2023-02-04 09:45:55',NULL),(6,'app_location','USA',NULL,'2023-02-02 17:51:06','2023-02-04 09:45:55',NULL),(7,'app_copyright','Developed by Zaiproty',NULL,'2023-02-02 17:51:06','2023-02-06 04:50:26',NULL),(8,'app_developed_by','Zaiproty',NULL,'2023-02-02 17:51:06','2023-02-04 09:45:55',NULL),(9,'currency_id','1',NULL,'2023-02-02 17:51:06','2023-02-06 07:09:23',NULL),(10,'language_id','1',NULL,'2023-02-02 17:51:06','2023-02-02 17:51:06',NULL),(11,'app_preloader_status','2',NULL,'2023-02-02 17:51:06','2023-02-02 17:51:06',NULL),(12,'sign_in_text_title','You are signing in Ziaproty',NULL,'2023-02-02 17:51:06','2023-02-04 09:45:55',NULL),(13,'sign_in_text_subtitle','You are signing in Ziaproty',NULL,'2023-02-02 17:51:06','2023-02-04 09:45:55',NULL),(14,'meta_keyword','Zaiproty',NULL,'2023-02-02 17:51:06','2023-02-04 09:45:55',NULL),(15,'meta_author','Zaiproty',NULL,'2023-02-02 17:51:06','2023-02-04 09:45:55',NULL),(16,'revisit',NULL,NULL,'2023-02-02 17:51:06','2023-02-02 17:51:06',NULL),(17,'sitemap_link',NULL,NULL,'2023-02-02 17:51:06','2023-02-02 17:51:06',NULL),(18,'meta_description','Zaiproty',NULL,'2023-02-02 17:51:06','2023-02-04 09:45:55',NULL),(23,'website_primary_color','#3686FC',NULL,'2023-02-04 09:46:20','2023-02-06 07:08:05',NULL),(24,'website_secondary_color','#8253FB',NULL,'2023-02-04 09:46:20','2023-02-06 07:08:14',NULL),(25,'button_primary_color','#3686FC',NULL,'2023-02-04 09:46:20','2023-02-06 07:08:21',NULL),(26,'button_hover_color','#0063E6',NULL,'2023-02-04 09:46:20','2023-02-06 07:08:26',NULL),(27,'website_color_mode','0',NULL,'2023-02-04 09:46:20','2023-02-06 07:08:05',NULL),(28,'gateway_settings','{\"paypal\":[{\"label\":\"Url\",\"name\":\"url\",\"is_show\":0},{\"label\":\"Client ID\",\"name\":\"key\",\"is_show\":1},{\"label\":\"Secret\",\"name\":\"secret\",\"is_show\":1}],\"stripe\":[{\"label\":\"Url\",\"name\":\"url\",\"is_show\":0},{\"label\":\"Public Key\",\"name\":\"key\",\"is_show\":1},{\"label\":\"Secret Key\",\"name\":\"secret\",\"is_show\":0}],\"razorpay\":[{\"label\":\"Url\",\"name\":\"url\",\"is_show\":0},{\"label\":\"Key\",\"name\":\"key\",\"is_show\":1},{\"label\":\"Secret\",\"name\":\"secret\",\"is_show\":1}],\"instamojo\":[{\"label\":\"Url\",\"name\":\"url\",\"is_show\":0},{\"label\":\"Api Key\",\"name\":\"key\",\"is_show\":1},{\"label\":\"Auth Token\",\"name\":\"secret\",\"is_show\":1}],\"mollie\":[{\"label\":\"Url\",\"name\":\"url\",\"is_show\":0},{\"label\":\"Mollie Key\",\"name\":\"key\",\"is_show\":1},{\"label\":\"Secret\",\"name\":\"secret\",\"is_show\":0}],\"paystack\":[{\"label\":\"Url\",\"name\":\"url\",\"is_show\":0},{\"label\":\"Public Key\",\"name\":\"key\",\"is_show\":1},{\"label\":\"Secret Key\",\"name\":\"secret\",\"is_show\":0}],\"mercadopago\":[{\"label\":\"Url\",\"name\":\"url\",\"is_show\":0},{\"label\":\"Client ID\",\"name\":\"key\",\"is_show\":1},{\"label\":\"Client Secret\",\"name\":\"secret\",\"is_show\":1}],\"sslcommerz\":[{\"label\":\"Url\",\"name\":\"url\",\"is_show\":0},{\"label\":\"Store ID\",\"name\":\"key\",\"is_show\":1},{\"label\":\"Store Password\",\"name\":\"secret\",\"is_show\":1}],\"flutterwave\":[{\"label\":\"Hash\",\"name\":\"url\",\"is_show\":1},{\"label\":\"Public Key\",\"name\":\"key\",\"is_show\":1},{\"label\":\"Client Secret\",\"name\":\"secret\",\"is_show\":1}],\"coinbase\":[{\"label\":\"Hash\",\"name\":\"url\",\"is_show\":0},{\"label\":\"API Key\",\"name\":\"key\",\"is_show\":1},{\"label\":\"Client Secret\",\"name\":\"secret\",\"is_show\":0}]}',NULL,'2023-02-22 20:49:54','2023-02-22 20:49:54',NULL);

INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
                                                          (1, '2014_10_12_000000_create_users_table', 1),
                                                          (2, '2014_10_12_100000_create_password_resets_table', 1),
                                                          (3, '2019_08_19_000000_create_failed_jobs_table', 1),
                                                          (4, '2019_12_14_000001_create_personal_access_tokens_table', 1),
                                                          (5, '2022_06_14_123059_create_metas_table', 1),
                                                          (6, '2022_06_23_121213_create_settings_table', 1),
                                                          (7, '2022_06_25_110824_create_currencies_table', 1),
                                                          (8, '2022_06_25_111037_create_languages_table', 1),
                                                          (9, '2022_10_03_070043_create_transactions_table', 1),
                                                          (10, '2022_11_26_183258_create_file_managers_table', 1),
                                                          (11, '2022_11_30_040739_create_gateways_table', 1),
                                                          (12, '2022_11_30_043112_create_invoice_types_table', 1),
                                                          (13, '2022_11_30_043152_create_ticket_topics_table', 1),
                                                          (14, '2022_12_02_143113_create_properties_table', 1),
                                                          (15, '2022_12_02_143115_create_property_details_table', 1),
                                                          (16, '2022_12_02_150206_create_property_units_table', 1),
                                                          (17, '2022_12_02_151705_create_property_images_table', 1),
                                                          (18, '2022_12_12_120950_create_expense_types_table', 1),
                                                          (19, '2022_12_12_121023_create_expenses_table', 1),
                                                          (20, '2022_12_14_124619_create_tenants_table', 1),
                                                          (21, '2022_12_14_152333_create_invoices_table', 1),
                                                          (22, '2022_12_15_072303_create_tenant_details_table', 1),
                                                          (23, '2022_12_19_184746_create_invoice_items_table', 1),
                                                          (24, '2022_12_24_055810_create_information_table', 1),
                                                          (25, '2022_12_24_134905_create_maintainers_table', 1),
                                                          (26, '2022_12_26_093722_create_notice_boards_table', 1),
                                                          (27, '2022_12_26_112846_create_notice_user_table', 1),
                                                          (28, '2023_01_03_075827_create_gateway_currencies_table', 1),
                                                          (29, '2023_01_07_120244_create_banks_table', 1),
                                                          (30, '2023_01_08_093333_create_kyc_verifications_table', 1),
                                                          (31, '2023_01_08_101846_create_kyc_configs_table', 1),
                                                          (32, '2023_01_11_113946_create_maintenance_issues_table', 1),
                                                          (33, '2023_01_11_130025_create_maintenance_requests_table', 1),
                                                          (34, '2023_01_12_131452_create_tickets_table', 1),
                                                          (35, '2023_01_22_070829_create_ticket_replies_table', 1),
                                                          (36, '2023_01_30_071830_create_orders_table', 1),
                                                          (37, '2023_02_01_094211_create_notifications_table', 1),
                                                          (38, '2023_02_07_131801_create_invoice_recurring_settings_table', 2),
                                                          (39, '2023_02_07_132102_create_invoice_recurring_setting_items_table', 2),
                                                          (40, '2023_02_08_070028_add_field_to_invoices_table', 2),
                                                          (41, '2023_03_06_115256_change_filed_to_tenant_details_table', 3),
                                                          (42, '2023_03_06_125634_add_field_to_invoice_types_table', 3),
                                                          (43, '2023_03_06_131839_add_field_to_expense_types_table', 3),
                                                          (44, '2023_03_06_140942_add_field_to_invoice_items_table', 3),
                                                          (45, '2023_03_06_141916_add_field_to_invoices_table', 3),
                                                          (46, '2023_02_11_130034_create_packages_table', 4),
                                                          (47, '2023_02_26_123728_create_owners_table', 4),
                                                          (48, '2023_02_27_051537_add_field_to_users_table', 4),
                                                          (49, '2023_02_27_134555_create_owner_packages_table', 4),
                                                          (50, '2023_02_28_060601_add_dependency_field_for_multi_owner_saas', 4),
                                                          (51, '2023_03_20_071848_create_features_table', 4),
                                                          (52, '2023_03_20_100913_create_how_it_works_table', 4),
                                                          (53, '2023_03_20_122923_create_core_pages_table', 4),
                                                          (54, '2023_03_21_090904_create_testimonials_table', 4),
                                                          (55, '2023_03_21_095818_create_faqs_table', 4),
                                                          (56, '2023_03_23_130158_create_subscription_orders_table', 4),
                                                          (57, '2023_03_28_063823_create_tax_settings_table', 4),
                                                          (59, '2023_06_12_095437_create_sms_histories_table', 1),
                                                          (60, '2023_06_14_062807_create_mail_histories_table', 1),
                                                          (61, '2023_06_19_120927_create_messages_table', 1),
                                                          (62, '2023_06_20_094453_add_field_type_to_tenants_table', 1),
                                                          (63, '2016_06_01_000001_create_oauth_auth_codes_table', 5),
                                                          (64, '2016_06_01_000002_create_oauth_access_tokens_table', 5),
                                                          (65, '2016_06_01_000003_create_oauth_refresh_tokens_table', 5),
                                                          (66, '2016_06_01_000004_create_oauth_clients_table', 5),
                                                          (67, '2016_06_01_000005_create_oauth_personal_access_clients_table', 5),
                                                          (68, '2023_05_15_105919_add_field_font_id_to_languages_table', 5),
                                                          (69, '2023_07_05_074548_create_agreement_histories_table', 5),
                                                          (70, '2023_07_12_062906_add_field_to_users_table', 5),
                                                          (71, '2023_07_12_112338_add_field_to_properties_table', 5),
                                                          (72, '2023_07_19_074820_create_tenancies_table', 5),
                                                          (73, '2023_07_19_074850_create_domains_table', 5),
                                                          (74, '2023_07_20_061535_change_decimal_number', 5),
                                                          (75, '2023_07_20_065853_add_field_verify_token_to_users_table', 5),
                                                          (76, '2023_07_31_070327_add_field_otp_to_users_table', 5),
                                                          (77, '2023_08_17_065719_create_email_templates_table', 6),
                                                          (78, '2023_08_26_074018_create_listings_table', 6),
                                                          (79, '2023_08_26_075152_create_listing_information_table', 6),
                                                          (80, '2023_08_27_071047_create_listing_images_table', 6),
                                                          (81, '2023_08_29_092825_create_listing_contacts_table', 6),
                                                          (82, '2023_09_04_061231_add_fields_to_owners_table', 6),
                                                          (83, '2023_09_20_064103_add_fields_to_property_units_table', 7),
                                                          (84, '2023_11_08_121707_change_dependency_field_for_package', 8),
                                                          (85, '2024_02_07_103858_add_others_field_to_packages_table', 9),
                                                          (86, '2024_02_29_113454_add_field_late_fee_to_invoices_table', 10),
                                                          (87, '2024_03_09_151213_add_column_to_maintenance_requests_table', 10),
                                                          (88, '2024_09_25_053925_create_permission_tables', 10),
                                                          (89, '2024_09_25_092211_create_package_gateway_prices_table', 10),
                                                          (90,'2025_02_09_112229_create_blogs_table',12),
                                                          (91,'2025_02_09_112244_create_blog_categories_table',12),
                                                          (92,'2025_02_11_091527_add_column_to_packages_table',12),
                                                          (93,'2025_07_13_091411_create_chats_table',13),
                                                          (94,'2025_07_13_104618_add_column_user_table',14),
                                                          (95,'2025_07_14_101114_add_column_in_maintenance_requests_table',15);

SET FOREIGN_KEY_CHECKS=1;

DROP TABLE IF EXISTS `package_gateway_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `package_gateway_prices` (
                                          `id` bigint unsigned NOT NULL AUTO_INCREMENT,
                                          `gateway_id` bigint unsigned NOT NULL,
                                          `gateway_currency_id` bigint unsigned NOT NULL,
                                          `package_id` bigint unsigned NOT NULL,
                                          `gateway` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                                          `monthly_price_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                                          `yearly_price_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
                                          `status` tinyint NOT NULL DEFAULT '1',
                                          `created_at` timestamp NULL DEFAULT NULL,
                                          `updated_at` timestamp NULL DEFAULT NULL,
                                          PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `chats`
--

DROP TABLE IF EXISTS `chats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `chats` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `sender_id` int NOT NULL DEFAULT '0',
  `receiver_id` int NOT NULL DEFAULT '0',
  `message` longtext COLLATE utf8mb4_unicode_ci,
  `is_seen` int NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chats`
--
